<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_ControllerPublic_Register extends XFCP_sonnbStopSpamHere_ControllerPublic_Register
{
	public function actionIndex()
	{
        $sshModel = sonnbStopSpamHere_Model_SSH::getInstance();
		
		if (XenForo_Application::isRegistered('session') && $sshModel->registerMinimumSubmitTime)
		{
			$session = XenForo_Application::getSession();
			
			try
			{
				$session->set('sonnbSSH_startTime', XenForo_Application::$time);
			}catch (Exception $e){}
		}
		
		return parent::actionIndex();
	}
	
    public function actionRegister()
    {
        $sshModel = sonnbStopSpamHere_Model_SSH::getInstance();
        
        /*
         * Check if user submit this form to fast according to configured value in ACP options
         */
        if (XenForo_Application::isRegistered('session') && $sshModel->registerMinimumSubmitTime)
        {
        	$session = XenForo_Application::getSession();
        	if (!$session->isRegistered('sonnbSSH_startTime'))
        	{
        		$this->throwError('directly_submit');
        	}
        	
        	$startTime = $session->get('sonnbSSH_startTime');
        	if (!$startTime || $startTime > strtotime('- '.$sshModel->registerMinimumSubmitTime.' seconds'))
        	{
        		$this->throwError('to_fast_submit');
        	}        	
        }
        /*
         * End of checking
         */
        
        //Get user inputs
        $input = $this->_input->filter(array(
            'username' => XenForo_Input::STRING,
            'email' => XenForo_Input::STRING,
        ));
        
        /*
         * Integrate with addon: FoolBotHoneyPot
         */
        if (class_exists('FoolBotHoneyPot_Model_HoneyPot'))
        {
        	$addOnModel = $this->getModelFromCache('XenForo_Model_AddOn');
        	$addon = $addOnModel->getAddOnById('FoolBotHoneyPot');
        	if ($addon && $addon['active'])
        	{
        		$uuids = $this->getModelFromCache('FoolBotHoneyPot_Model_HoneyPot')->getFeildUUIDs();
        		
        		$fields = $this->_input->filter(array(
        				$uuids['1'] => XenForo_Input::STRING, //username
        				$uuids['2'] => XenForo_Input::STRING, //email
        		));
        		
        		$input['username'] = $fields[$uuids['1']];
        		$input['email'] = $fields[$uuids['2']];
        	}
        }
        /*
         * End of integration
         */
        
        //Get user ip
        $input['ip'] = $sshModel->getUserIP();

        if ($sshModel->registerCheck)
        {
            if ($sshModel->registerCheckField)
            {
                $hiddenField = $this->_input->filterSingle('sonnbSSH_field', XenForo_Input::STRING);
                if ($hiddenField)
                {
                    $sshModel->saveLog(array(
                        'username' => $input['username'],
                        'email' => $input['email'],
                        'content_type' => sonnbStopSpamHere_Model_SSH::TYPE_REGISTER,
                        'content_id' => 0,
                        'log_type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_REGISTER,
                        'data' => serialize(array()),
                        'action' => sonnbStopSpamHere_Model_SSH::ACTION_BLOCK
                    ));
                
                    $this->throwError();  
                }
            }
            
            $action = $sshModel->checkRegister($input);

            if ($action)
            {
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_REGISTER,
                    'data' => $action['data']
                );

                switch ($action['action'])
                {
                    case "block":
                        $sshModel->saveLog(array(
                            'username' => $input['username'],
                            'email' => $input['email'],
                            'content_type' => sonnbStopSpamHere_Model_SSH::TYPE_REGISTER,
                            'content_id' => 0,
                            'log_type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_REGISTER,
                            'data' => serialize($action['data']),
                            'action' => sonnbStopSpamHere_Model_SSH::ACTION_BLOCK
                        ));
                        $this->throwError();
                        break;
                    case "moderate":
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_MODERATE] = $dwData;
                        break;
                    case "discourage":
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_DISCOURAGE] = $dwData;
                        break;
                    case "allow":
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }
        
        if ($sshModel->registerCheckPoint)
        {
            $point = 0;
            
            $point += $sshModel->getPointIP();
            
            $point += $sshModel->getPointEmail($input['email']);
            
            $point += $sshModel->getPointUsername($input['username']);
            
            $action = $sshModel->checkPointLimit($point);
            
            if ($action)
            {
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_REGISTER,
                    'data' => $input + array('service' => get_class($sshModel))
                );
                    
                switch($action)
                {
                    case "block":
                        $sshModel->saveLog(array(
                            'username' => $input['username'],
                            'email' => $input['email'],
                            'content_type' => sonnbStopSpamHere_Model_SSH::TYPE_REGISTER,
                            'content_id' => 0,
                            'log_type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_REGISTER,
                            'data' => serialize($action['data']),
                            'action' => sonnbStopSpamHere_Model_SSH::ACTION_BLOCK
                        ));
                        $this->throwError('point');
                        break;
                    case "moderate":
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_MODERATE] = $dwData;
                        break;
                    case "discourage":
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_DISCOURAGE] = $dwData;
                        break;
                    case "allow":
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
            
        }
        
        $parent = parent::actionRegister();
        
        /*
         * Re-initital timer if user had fail to register
         */
        if (!empty($parent->params['errors']))
        {
        	if (XenForo_Application::isRegistered('session'))
        	{
        		$session = XenForo_Application::getSession();
        		
	        	try
				{
					$session->set('sonnbSSH_startTime', XenForo_Application::$time);
				}catch (Exception $e){}
        	}
        }
        
        return $parent;
    }
    
    public function throwError($type='default')
    {
        switch ($type)
        {
            case 'point':
                $phrase = new XenForo_Phrase(
                            'sonnbStopSpamHere_registration_stop_message_point',
                            array('contactUrl' => sonnbStopSpamHere_Model_Log::getContactUrl())
                        );
                break;
            case 'default':
                $phrase = new XenForo_Phrase(
                            'sonnbStopSpamHere_registration_stop_message_default',
                            array('contactUrl' => sonnbStopSpamHere_Model_Log::getContactUrl())
                        );
                break;
            case 'directly_submit':
            	$phrase = new XenForo_Phrase('sonnbStopSpamHere_directly_registration_via_post_is_not_allowed');
            	break;
            case 'to_fast_submit':
            	$phrase = new XenForo_Phrase('sonnbStopSpamHere_please_take_time_you_are_submitting_to_fast');
            	break;
            default:
                break;
        }
        
        throw $this->responseException($this->responseError($phrase, 403));
    }

}